curDesktop := 3
newDesktop := 2
direction := determineArrowDirection(curDesktop, newDesktop)
arrow := determineArrowDirection(curDesktop, newDesktop)

;===== Illustration for Switch =====
;could be used for the transition animations
;might be used for selecting a space
Gui, +AlwaysOnTop -Caption ;+ToolWindow
Gui, Color, 000000
Gui, add, picture,   , % addSpaceImage(1)   ;%
Gui, add, picture,   , % addSpaceImage(3)   ;%
Gui, add, picture,ys , % addSpaceImage(2)   ;%
Gui, add, picture,   , % addSpaceImage(4)   ;%
image := addSpaceImage(2)
image := addSpaceImage(3)
image := addSpaceImage(4)


;Gui, add, picture,ys   , newDesktop.png
;Gui, add, picture,   , arrowUp.png
;Gui, add, picture,ys , inactiveDesktop.png
;Gui, add, picture,   , inactiveDesktop.png
Gui, show, ;h128 w128


keywait, Esc
exitApp
sleep 1000

;===== Fullscreen screenshot display =====
;could be used for a grand view of all spaces
;could also be used for the transition animations
Gui 2: +AlwaysOnTop -Caption
Gui 2: add, picture, x0 y0 , screenshot.png	;there is a gray border that they x0 y0 positioning deals with
Gui 2: show


sleep 1000
exitApp

addSpaceImage(space)
{
	global newDesktop
	global curDesktop
	global arrow
	
	if (space = newDesktop)
		image = newDesktop.png
	else if (space = curDesktop)
		{
		image = %arrow%
		}
	else image = inactiveDesktop.png
	
	image := "imgs/" . %image%	;navigate to images folder
	msgbox %image%
	return image
}

determineArrowDirection(curDesktop, newDesktop)
{
	diff := newDesktop - curDesktop
	if diff = 0
		msgbox This is the same desktop
	else if (diff = 1)	;1>2, (2>3), 3>4					right
		arrow = arrowRight.png
	else if diff = -1	;2>1, (3>2), 4>3
		arrow = arrowLeft.png
	else if (abs(diff) = 2)	;UP(3>1, 4>2) DOWN(1>3, 2>4)
	{
		if (curDesktop <= 2)
			arrow = arrowDown.png
		else if (curDesktop >= 3)
			arrow = arrowUp.png
		else msgbox we have a problem  :^(
	}
	else arrow = inactiveDesktop.png	;don't display an arrow
	return arrow
}

flash(text)
{
	tooltip %text%
	sleep 800
	tooltip
}



;A Failure at Partial Transparency_____________
;sleep 1000	;partial transparency is impossible
;Gui 2: Color, F0F0F0
;Gui 2: +LastFound +AlwaysOnTop
;Gui 2: Add, picture, , selector.png
;Gui 2: Show
;WinSet, TransColor, F0F0F0, A
;Gui 2: -Caption